#ifndef _IOCTL_UPDATE_H
#define _IOCTL_UPDATE_H

/*******************************************************************************
 * Unicast address manipulcation commands (IOCTL).
 */

/*
 * First we define the "LAST_IOCTL_CMDID_IN_USE" to the largest number
 * that is in use by anybody (eg. VxWorks / SENS ). Then define our range
 * to start from the next available ID.
 * 
 * Mike: Move this to the <superPIPE BSP>/IOCTL.h. Doing this "exports"
 * these UCast IOCTL cmd defines to their users, eg "protocols".
 */

#define LAST_IOCTL_CMDID_IN_USE 300
#define EIOCUNIADD _IOW('i', (LAST_IOCTL_CMDID_IN_USE + 1), char *)	/* add */
#define EIOCUNIDEL _IOW('i', (LAST_IOCTL_CMDID_IN_USE + 2), char *)	/* del */
#define EIOCUNIGET _IOWR('i', (LAST_IOCTL_CMDID_IN_USE + 3), UNI_TABLE) /* get */
#define EIOCUNIDELALL _IOWR('i', (LAST_IOCTL_CMDID_IN_USE + 4), UNI_TABLE) /* del all */
#define EIOCMULTIDELALL _IOWR('i', (LAST_IOCTL_CMDID_IN_USE + 5), UNI_TABLE) /* del all */

#endif /* _IOCTL_UPDATE_H */