/*
 *  Module Name: buffobj.c : OS_DEPENDENT
 *  Author: Bright Shih
 *  Date : 5/30/2001
 *
 *  Module Description: Buffer handling (VXWORKS)
 *
 *  Assumptions:
 *
 */
#define BUFFOBJ_MODULE

#include "emac_end.h"
#include "buffobj.h"
#include "jedidbg.h"
#include "osutil.h"

ADDR_TBL * Get_Free_Tx_Buffer( PMACAPI MACAdapter )
{
	DMA_BUFFER DmaBuffer ;

	if( (DmaBuffer = DMABUFFER_Allocate_A_DmaBuffer( MACAdapter->pDmaBuffObj ) ) == NULL )
	{
		MACAdapter->txMIB.outofDmaBuffer++;
		MACAdapter->endObj.mib2Tbl.ifOutDiscards ++;
	}

	return DmaBuffer ;
}

// interfaces from MAC to HPNALL
// access hardware to send a packet, NDIS does not have race condition,
// check other OSs
// this routine can be called by timer event and xmit


// BOOL Control_Frame  is useless for VXWORKS
void MAC_Send_A_Frame(PMACAPI MACAdapter, U32 PacketSize, ADDR_TBL *PtrTxBuffer, BOOLEAN Control_Frame )
{
	// if fail to send , driver can choose to queue or drop the packet
	// Since EMAC DMA TX engine can queue the packet , driver no need to queue

#ifdef DIRECT_DMA_API
	if( !EMACDMATX_SendDMABUFFER( MACAdapter->pDmaTxObj,
		PtrTxBuffer, PacketSize,
		( (Control_Frame == MT_SETUP_FRAME) ? MT_SETUP_FRAME : 0 ) ) )
#else
	if( !DmaSendDmaBuffer( MACAdapter->DmaTxChannel,
		PtrTxBuffer, PacketSize,
		( (Control_Frame == MT_SETUP_FRAME) ? MT_SETUP_FRAME : 0 ) ) )
#endif
	{
		MACAdapter->endObj.mib2Tbl.ifOutDiscards ++;
		DMABUFFER_Release_A_DmaBuffer( PtrTxBuffer ) ;
	}
}

void _fastcall MAC_Assign_MacAddress( PMACAPI MACAdapter, U8 *S_Addr )
{

	MOVE_MEMORY( S_Addr, MACAdapter->PortNetAddress, 6 ) ;
}

#define DA_Offset 0
// TBD : can be removed
BOOL MAC_Need_To_Process_This_Frame( PMACAPI MACAdapter, U8 *Frame )
{
	return YES ;
}

#ifdef BRIDGE
int MAC_Bridge_Unit( PMACAPI MACAdapter )
{
	return MACAdapter->unit ? 0 : 1  ;
}
#endif


/*########## CWC, 07/22/02 ##########*/
#ifndef BUILD_BOOTROM

static U32 Random_Seed = 0 ;
static void MAC_Get_Random_Seed( PMACAPI MACAdapter )
{
	U32 tmp ;

	Random_Seed = (U32)&tmp  ;	//

	if( Random_Seed < 0x7fff )
		Random_Seed += 0x7fff ;
}

U16 MAC_Get_Random_Number( PMACAPI MACAdapter )
{

	if( !Random_Seed )	// not initialized
		MAC_Get_Random_Seed( MACAdapter ) ;

	/* linear congruential */
	Random_Seed = (Random_Seed * 1103515245 + 12345) & 0x7fffffff;

//   DbgPrint(" Random = %X : \n", MACAdapter->Random_Seed);

	return (U16)Random_Seed ;
}

PVOID MAC_Get_OSRXPACKET_ObjPtr( PMACAPI MACAdapter )
{

	return MACAdapter->pOsPk ;
}

#endif /* BUILD_BOOTROM */
