/*
 *  Module Name: phytypes.h
 *  Author: Joe Bonaker
 *
 *  Copyright  Rockwell Semiconductor Systems 1997-1998.  All rights reserved.
 *
 *  Module Description: PHY driver OS/compiler mapping of simple
 *  BYTE/WORD/DWORD types.
 *
 * $Log: Phytypes.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:36  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/12/23 10:28:51  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/11/21 08:29:25  SHAO-GH
 * 2003.11.20 Shao Guohua use win cvs first time from sourcesafe 
 *
 * 
 *    Rev 1.7   Aug 07 2002 16:32:12   nguyenpa
 *  
 * 
 *    Rev 1.6   Oct 03 2001 18:43:22   shihbl
 * support HPNA2.0, HOMEPLUG and ETHENT PHYs
 * 
 *    Rev 1.3   Jun 12 2001 18:53:34   shihbl
 *  
 * 
 *    Rev 1.2   18 Apr 2001 18:57:42   shihbl
 * 1. LINUX porting
 * 2. RRCF request up to PE 7
 * 3. bit 14 H2_CARR_H1GATE for register 0x8000
 * 
 *    Rev 1.1   24 Jan 2000 19:33:04   shihbl
 * CSA and LICF work
 * 
 *    Rev 1.1   May 12 1999 12:06:04   wangmx
 *  
 * Revision 1.10  1998/03/26 17:16:12  bonakeaj
 * - rss_ prefix added when (DRV_OS == SCO_*)
 * Revision 1.9  1998/02/12 19:04:52  bonakeaj
 * - RSS 11617 R15 GPIO PHY_HWRESET(), WIN32_DIAG NT 4.0 merge
 * Revision 1.8  1998/01/23 20:36:40  bonakeaj
 * - Davicom PHY and DRV_OS=SCO_MDI support
 * Revision 1.7  1998/01/08 14:48:30  bonakeaj
 * - Merged WIN32_DIAG support for NT 4.0
 * Revision 1.6  1997/09/12 00:05:36  bonakeaj
 * - DRV_OS=LINUX port
 * Revision 1.5  1997/08/21 21:56:20  kamstrd
 * - Updated copyright headers
 * - Replaced RW116?? with RSS116??
 * - Replaced RW11606 with RSS1161x in some comments
 * Revision 1.4  1997/08/01 23:18:54  bonakeaj
 * - DRV_OS=NOVELL_CHSM changes (minor) to support Novell
 * - CHSM-32 driver integration
 * Revision 1.3  1997/07/17 20:57:28  bonakeaj
 * - Added DRV_OS=WIN32_DIAG, and PHY_CONN_ANY_* support
 * Revision 1.2  1997/07/12 02:24:12  bonakeaj
 * - Added PHY_LINK_NEW_MEDIA support, minor type changes for
 * - NDIS 3.1 macApi/phyDrv integration, and fixed PhyInit() bug where
 * - PhyDisable()'s isolate action prevented Auto-Negotiation
 * - completion with the NSC DP83840 PHY device.
 **********************************************************************/

#ifndef _PHYTYPES_H_
#define _PHYTYPES_H_

/*----------------------------------------------------------------------
 * OS and compiler-specific types here, based on DRV_OS complier switch
 *--------------------------------------------------------------------*/
#define NDIS            1
#define NOVELL_CHSM     2
#define DRV_OS_UNUSED   3       /* was "SCO" ... see SCO_*, below */
#define SOLARIS         4
#define LINUX           5
#define PKTDRV          6
#define DOS             7
#define WIN32_DIAG      8       /* RSS' Win95/NT diagnostic tool */
#define SCO_MDI         9
#define SCO_LLI        10
#define SCO_DLPI       11
#define SCO_GEMINI     12
#define VXWORKS        13		/* VxWorks Tornado RTOS */
#define NO_OS          14		/* No OS Services */

#ifndef DRV_OS
#define DRV_OS  DOS     /* THE lowest common denominator :-/ */
#endif

#if (DRV_OS == NDIS)
#include <ndis.h>
#if !defined(_TYPDEF_H_)
typedef ULONG DWORD;
typedef USHORT WORD;
typedef UCHAR BYTE;
#endif

#elif (DRV_OS == NOVELL_CHSM)
#include <odi.h>
#include <odi_nbi.h>
#include <cmsm.h>

#ifndef BYTE
typedef UINT8           BYTE;
#endif

#ifndef WORD
typedef UINT16          WORD;
#endif

#ifndef DWORD
/* Warning:  <odi.h> UINT32 == unsigned int, not unsigned long */
typedef unsigned long   DWORD;
#endif

#elif (DRV_OS == SCO_MDI)
typedef int             BOOLEAN;
typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;

#elif (DRV_OS == SCO_LLI)
typedef int             BOOLEAN;
typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;

#elif (DRV_OS == SCO_DLPI)
typedef int             BOOLEAN;
typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;

#elif (DRV_OS == SCO_GEMINI)
typedef int             BOOLEAN;
typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;

#elif (DRV_OS == SOLARIS)
#include <sys/types.h>
#include <sys/ddi.h>
#include <sys/sunddi.h>
typedef int             BOOLEAN;
typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;

#elif (DRV_OS == LINUX)
#include <linux/delay.h>
/* #include <asm/delay.h> */
#include <asm/io.h>
#if !defined(_TYPDEF_H_) 
typedef int             BOOLEAN;
typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;
#endif

#elif (DRV_OS == VXWORKS)	/* VxWorks Tornado RTOS */
#if !defined(_TYPDEF_H_) && !defined(BSPTYPES_H)
typedef int             BOOLEAN;
typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;
#endif

#elif (DRV_OS == PKTDRV)
#include <pktdrv???.h>

#elif (DRV_OS == WIN32_DIAG)
#include <windows.h>
#include "RockDLL.h"    /* NIC diagnostics DLL */

#else                   /* DOS -- Roll our own basic types */
#if !defined(_TYPDEF_H_)
typedef int             BOOLEAN;
typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;
#endif

#endif
/*--------------------------------------------------------------------*/

/* Be sure the essentials are in place */
#ifndef TRUE
#define TRUE            1
#endif
#ifndef FALSE
#define FALSE           0
#endif
#ifndef NULL
#define NULL            ((void *) 0)
#endif

#endif /* _PHYTYPES_H_ */
