/****************************************************************************
* $Header: E:/WorkCVS/NP66/hasbani/APPS/EMAC/MACPHY.H,v 1.1.1.1 2004/04/01 09:10:05 shao-gh Exp $
*
*  Copyright(c)2000  Conexant Systems
*
*****************************************************************************/
#if !defined(MACPHY_H_)
#define	MACPHY_H_

#include "phytypes.h"

typedef enum def_PHY_HARDRESET
{
HWRESET_NO = 0 ,	// no Phy hardware reset required
HWRESET_ROMCS,		// Phy hardware reset through ROM chipsel
HWRESET_GPIO,		// Phy hardware reset through GPIO (currently GPIO 0)
} PHY_HARDRESET;

void MacPhyHwReset( DWORD mac_address, PHY_HARDRESET HwResetOpt) ;
void MacPhyD3Set( DWORD mac_address, PHY_HARDRESET HwResetOpt ) ;
void MacPhyD0Set ( DWORD mac_address, PHY_HARDRESET HwResetOpt ) ;

void MacPhy_Stop_And_Wait_TXRX_Complete(DWORD mac_address ) ;
void MacPhy_Configure_Mac( DWORD mac_address, BOOLEAN Port_Mii,  BOOLEAN Speed100m, BOOLEAN Full_Duplex ) ;


/*
	void MacPhyHwReset( DWORD mac_address, PHY_HARDRESET HwResetOpt) ;
		MAC hardware reset the PHY(s), need porting for different MAC
		For 116xx we may pick GPIO0 or FROM_CS to hard reset the PHY(s)
		JEDI and some Ethernet phy do not need hardware reset
		Redownload code required for JEDI phy after hardware reset.

	 Parameters :
		DWORD mac_address : beginning of MAC IO address
		PHY_HARDRESET HwResetOpt :
			HWRESET_NO: no Phy hardware reset required
			HWRESET_ROMCS: Phy hardware reset through ROM chipsel
			HWRESET_GPIO: Phy hardware reset through GPIO (currently GPIO 0)
	 Return Value :
	 Comment :
*/

/*
	void MacPhyD3Set( DWORD mac_address, , PHY_HARDRESET HwResetOpt ) ;
		MAC may need to do something to PHY when system suspend
	 Parameters :
		DWORD mac_address : beginning of MAC IO address
		PHY_HARDRESET HwResetOpt :
			HWRESET_NO: no Phy hardware reset required
			HWRESET_ROMCS: Phy hardware reset through ROM chipsel
			HWRESET_GPIO: Phy hardware reset through GPIO (currently GPIO 0)
	 Return Value :
	 Comment :
*/

/*
	void MacPhyD3Set( DWORD mac_address, PHY_HARDRESET HwResetOpt ) ;
		MAC may need to do something to PHY when system resume
	 Parameters :
		DWORD mac_address : beginning of MAC IO address
		PHY_HARDRESET HwResetOpt :
			HWRESET_NO: no Phy hardware reset required
			HWRESET_ROMCS: Phy hardware reset through ROM chipsel
			HWRESET_GPIO: Phy hardware reset through GPIO (currently GPIO 0)
	 Return Value :
	 Comment :
*/

/*
	void MacPhy_Stop_And_Wait_TXRX_Complete(DWORD mac_address ) ;
		ask MAC to stop TX and RX, wait all pending packets finished
	 Parameters :
		DWORD mac_address : beginning of MAC IO address
	 Return Value :
	 Comment :
*/

/*
	void MacPhy_Configure_Mac( DWORD mac_address, BOOLEAN Port_Mii,  BOOLEAN Speed100m, BOOLEAN Full_Duplex ) ;
		PHY call this function to configure MAC register to match PHY settings
	 Parameters :
		DWORD mac_address : beginning of MAC IO address
		BOOLEAN Port_Mii: 
			TRUE: configure MAC MII interface
			FALSE: configure MAC 7WS interface 
		BOOLEAN Speed100m: 
			TRUE: configure MAC device speed 100M
			FALSE: configure MAC device speed 1/10M
		BOOLEAN Full_Duplex:
			TRUE: configure MAC full duplex
			FALSE: configure MAC half duplex
			
	 Return Value :
	 Comment :
		The current code assume MAC can support up to two PHYs (JEDI and Ethernet PHY)
		Only on PHY can be active. PHY call this routine to configure MAC to the right 
		mode.
*/
#endif
