 /*************************************************************
Note, use extern 1 functions:
       a) CFGWriteConfig();
       b) int update_menu_htm (void);
       c) int HTTPMSGInit (void)(void);

2002.06.21 add: Note,  
    Suppose Lan port ip is 192.168.168.1, now use routeAdd to add a route table as below:
       Destination Host    gateway           interface
           2.2.2.2       192.168.168.2      192.168.168.1(lan ip)
     Of couse, gateway ip 192.168.168.2 is deceiving ip. But for Vxworks, OS will send a arp 
     request packet, its sender ip and target ip are both 192.168.168.2, but its mac address is Lan 
     ports Mac address. It will cause fatal problem in the network. 
     (In windows, OS will not send such arp packet).
     So I add a outpout hook(UconfigLanSendMacHook) to delete the arp packet.      

	 At the same time, I need to discard the receiving packet which conflict with my deceiving arp/route table.
     
*************************************************************/
#include "vxworks.h"
#include "memLib.h"
#include "net/if_dl.h"
#include <netinet/if_ether.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include "inetLib.h"
#include "routeLib.h"
#include "string.h"
#include "fiolib.h"
#include "stdio.h"
#include "arpLib.h"
#include "iflib.h"
#include "muxlib.h"
#include "stdlib.h"
#include "netinet/ip.h"
#include "netinet/udp.h"
#include "tasklib.h"
#include <etherLib.h>
#include <ioLib.h>
#include <sockLib.h>
#include <rebootLib.h>

#include "xxxUconfiglib.h"


#define NPFIND_MSG_MAXLEN       	1500
#define NPFIND_PROT_VERSION      	3
#define UCONFING_NPFIND_UDP_PORT   	7778
#define NPFIND_MAGIC_NUMBER     	0x89168ACE

#define SYSMSG_CODE_NPFIND_QUERY   		  1  //uConfig.exe send NPFind request packet to all devices
#define SYSMSG_CODE_NPFIND_REPLY   		  2  //device send responded packet to uConfig.exe'sNPFind packet
#define SYSMSG_CODE_BEGIN_UCONFIG 		  3  //uConfig.exe Send Begin uConfig command to one selected device
#define SYSMSG_CODE_CHANGE_IP     		  4  //device send the packet to tell uConfig that its ip has benn changed
#define SYSMSG_CODE_CLOSE_UCONFIG  		  5  //uConfig and device exit uConfig mode
#define SYSMSG_CODE_NEED_NEW_ARP          6  //device send the packet to tell uConfig that it receive a arp request packet,
                                             //maybe it mean uConfig need to add a deceiving arp item into 
#define SYSMSG_CODE_PC_IP_CHANGED         7  //uConfig send packet to device that PC or workstations's ip is changed,                                             //windows arp table.

#define SYSMSG_CODE_BEGIN_UCONFIG_ACK 60  //device send the packet to tell uConfig that it has received the uConfig command
#define SYSMSG_CODE_CHANGE_IP_ACK      	  61 //uConfig.exe send the packet to tell device that it has known the device's ip has been changed.
#define SYSMSG_CODE_CLOSE_UCONFIG_ACK     62 //device send Ack to response uconfig.exe's command SYSMSG_CODE_CLOSE_UCONFIG
#define SYSMSG_CODE_PC_IP_CHANGED_ACK     63 //device send to PC/uCOnfig that it receive the packet

#define SYSMSG_CODE_BEGIN_UCONFIG_DENY 90  //device send the packet to tell uConfig that it deny enter uConfig command,ie, maybe 
                                              //device has already eneter uConfig mode by another uConfig.exe
                                              
char BroadCastMac[] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};
char ZeroMac[6]={0,0,0,0,0,0};

#define UCONFIG_MAGIC_STR1  "Uconfig======"  /*not more than 15 bytes*/
#define UCONFIG_MAGIC_STR2  "Uconfig------" /*not more than 15 bytes*/

/* SYSMSG_PACKET  is used as an interface packet between device and uConfig.exe */
typedef struct 
{
	//Below is used by all: Packet Header 
    unsigned long   magic_number;       //Packet header 1
    unsigned long   version;            //Packet header 2
    unsigned long   code;               //Packet header 3: Packet type 

    //Below is used only by device for sending packets to uConfig.exe.
    unsigned long   product_id;         //used by the packet from device during NPFind mode
    char    		product_model[32];	//used by the packet from device during NPFind mode
    char    		system_name[64];    //used by the packet from device during NPFind mode
    unsigned long   ip_address;         //used by the packet from device during NPFind mode
    unsigned long   old_ip_address;     //used if the device ip is changed. 

    //Below is used by all
    unsigned char   Src_mac[8];   // sender/Source Mac: add 2 bytes for memory align
    unsigned long   Src_ip;       // sender/Source mac
    unsigned char   Dest_mac[8];  //dest mac: add 2 bytes for memory align
	unsigned long   Dest_ip;      //dest IP	

	//Below varant is used by uCofig.exe to device
	unsigned long   Deceiving_Host_gateway; //uconfig.exe send packet to tell device its deceiving host Gateway.
	                                   //So that device will only send a SYSMSG_CODE_NEED_NEW_ARP packet
	                                   //to uConfig.exe if device receive a arp request packet to it. 
     //compex device send it to tell uconfig.exe its stutus: 
    unsigned long 	bfUconfigMode;  //0--not enter uConfig mode, 1--Already enter uConfig mode
	
} SYSMSG_UCONFIG_PACKET;


typedef struct ARP
{
    USHORT  hardware_type;
    USHORT  protocol_type;
    u_char   hardware_addr_len;
    char     protocol_addr_len;
    USHORT  opcode;
    char     sender_mac[6];
    struct	in_addr   sender_ip;
    char     target_mac[6];
    struct	in_addr  target_ip;
} __attribute__((__packed__)) ARP;


struct UconfigInternalPara
{
	 /*NPFind */
	struct ifnet* 	  	sysmsg_if;//= NULL;	
	char              	sysmsg_tx_buffer[100 + sizeof(SYSMSG_UCONFIG_PACKET)];
	int 			  	UconfigTaskID;//= 0;
	SEM_ID     			semB; 

	BOOL 				bfRebooting ;//= FALSE;

	/*Lan port Attribute*/
	                    
	unsigned long 		LanPortIP;//= 0;
	unsigned long 		LanPortMask;// = 0;
	char         		LanPortMac[6];
	                     
	ULONG  				gatewayIP;// = 0;


	ULONG               bfIPChangeAckFromWinApp;
	END_OBJ*			pLanEndObj;
	STATUS 				(*oldLanEndRtn) (void* pCookie, M_BLK_ID pMBlk); /*keep the lan port's original receive of its driver*/
	STATUS              (*oldLanEndSend) (END_OBJ* , M_BLK_ID);//keep the lan port's original send of its driver
};


static struct UconfigData uCfgData;
static struct UconfigData *pUCfgDataInConfigFile = NULL;
static struct UconfigInternalPara uConfigInnerParamter;
static SYSMSG_UCONFIG_PACKET   uConfigInterfacePacket; /*Must be global for */

/** operate Uconfig data in configfile */
BOOL SetUconfigDataMemAddr_Read( struct UconfigData *puCfgData, int bfColdReBoot);
static void SetDefaultUconfigData();
void SaveUconfigData();

/**Set lan port hook */
BOOL SetUconfigWithLanPort(char *DeviceName, int unit, char *LanIP, char *Mask, unsigned long product_ID, char *ProductNameWeb, char *sysName);
BOOL UconfigLanRecvMacHook(void* pCookie, M_BLK_ID pMblk);
BOOL UconfigLanSendMacHook(END_OBJ* pEndObj, M_BLK_ID pMBlk) ;
static BOOL SetUConfigStatus( M_BLK_ID pMblk);

/* Process Lan port hook */
static BOOL IsNPFindPacket(M_BLK_ID pMblk);
static BOOL IsBeginUConfigPacket(M_BLK_ID pMblk);
static BOOL IsQuitUConfigPacket(M_BLK_ID pMblk);
static BOOL IsuConfigArpRequestPacket( M_BLK_ID pMblk);
static BOOL IsPCIPCHANGEDUConfigPacket(M_BLK_ID pMblk);
static BOOL ProcessArpPacket(  M_BLK_ID pMblk);
static void ProcessPCIPChangedPacket( M_BLK_ID pMblk);
static BOOL ReplyNPFindPacket( M_BLK_ID pMblk);
static BOOL SendPacket(ULONG mode, ULONG NewIP, ULONG OldIP, ULONG DestIP, char* DestMac);
static BOOL SendPacket2(ULONG mode, ULONG NewIP, ULONG OldIP, ULONG DestIP, char* DestMac, ULONG version);

static ULONG GetUConfigPacketType(M_BLK_ID pMblk);
/*task to send packet to windows at fixed interval */
static void UconfigTask();

/*Other functions*/
static unsigned long checksum_d ( unsigned char *buf, int nbytes, unsigned long sum);
static unsigned long wrapsum (	unsigned long sum);
static void GetLanMac(char* Name, int unit, char *Mac);


/****** import Extern function ***********/
extern int update_menu_htm (void);
extern int HTTPMSGInit (void);
extern int CFGWriteConfig(void);


/**************************************************************
  Must be called before SetUconfigDataMemAddr_Read, 
  and Lan port ip/mask must be set( Reason: modify route table )
  call this function only once.
**************************************************************/
BOOL SetUconfigWithLanPort(char *DeviceName, int unit, char *LanIP, char *Mask, unsigned long product_ID, char *ProductNameWeb, char *sysName)
{
	char strDevice_Name_Unit[30];
	char tmp[30];
	BOOL Reset = FALSE;
	int    tmpMask;

	memset( &uConfigInnerParamter, 0, sizeof(uConfigInnerParamter) );
	uConfigInnerParamter.semB = semBCreate (SEM_Q_PRIORITY, SEM_FULL);
	
	uConfigInnerParamter.LanPortIP = inet_addr(LanIP);
	uConfigInnerParamter.LanPortMask = inet_addr(Mask);

	uConfigInnerParamter.pLanEndObj = endFindByName(DeviceName, unit);
	if( uConfigInnerParamter.pLanEndObj == NULL) 
	{
		printf("error: endFindByName \r\n");			
        	return FALSE;
	}
	
	Reset = FALSE;
	sprintf(strDevice_Name_Unit, "%s%d", DeviceName, unit);

	GetLanMac( DeviceName, unit, uConfigInnerParamter.LanPortMac);
	uConfigInnerParamter.sysmsg_if = ifunit(strDevice_Name_Unit);

	memset((char *)&uConfigInterfacePacket, 0, sizeof(uConfigInterfacePacket));
	uConfigInterfacePacket.product_id = htonl( product_ID );
	strcpy(uConfigInterfacePacket.product_model, ProductNameWeb);
	strcpy(uConfigInterfacePacket.system_name, sysName);

	uConfigInnerParamter.oldLanEndRtn = uConfigInnerParamter.pLanEndObj->receiveRtn;
        /*modify original lan recv hook to new Receive Hook*/
	uConfigInnerParamter.pLanEndObj->receiveRtn = UconfigLanRecvMacHook;

        //2002.6.21 add         
    uConfigInnerParamter.oldLanEndSend  =  uConfigInnerParamter.pLanEndObj->pFuncTable->send;
        /*modify original lan send hook to new send Hook*/
	uConfigInnerParamter.pLanEndObj->pFuncTable->send = UconfigLanSendMacHook;

	if( uCfgData.bfAreadyUconfig ) 
	{
		if( uConfigInnerParamter.UconfigTaskID == 0) 
		{
			uConfigInnerParamter.UconfigTaskID = taskSpawn( "TaskUconfig", 120, VX_PRIVATE_ENV, 5000, (FUNCPTR )UconfigTask,
	                                 0,0,0,0,0,0,0,0,0,0); 
			if( uConfigInnerParamter.UconfigTaskID == ERROR) 
			{
				printf("Error to create a task in SetUconfigWithLanPort\r\n");
			}
		}
		HTTPMSGInit();
		update_menu_htm();		
	}
	
	return TRUE;	
}



BOOL UconfigLanRecvMacHook(void* pCookie, M_BLK_ID pMblk)
{	
	semTake (uConfigInnerParamter.semB, WAIT_FOREVER);
	
	if( IsNPFindPacket( pMblk) ) 
	{			
		ReplyNPFindPacket( pMblk);
		netMblkClChainFree (pMblk); 
		goto EndXXX;
	}

	if( !uConfigInnerParamter.bfRebooting ) /*if device is rebooting, then not accept the packet */
	{
		if( IsBeginUConfigPacket( pMblk) )
		{  /*Begin/again Uconfig command packet*/
			SetUConfigStatus( pMblk) ;
			netMblkClChainFree (pMblk); 		
			
			goto EndXXX;
		}	
	}


	if( uCfgData.bfAreadyUconfig ) /*2002.06.21 */
	{
		if( IsArpPacketSamewithDeceivingGateway(pMblk) )
		{
			//printf("arp receving packet delete \r\n");
			netMblkClChainFree (pMblk);
	  		goto EndXXX;
		}
	}

	if( !uConfigInnerParamter.bfRebooting && uCfgData.bfAreadyUconfig ) /*if device is rebooting, then not accept the packet */
	{
		
		if( IsIPChangedACKUConfigPacket( pMblk) )
		{  /*Begin/again Uconfig command packet*/
			uConfigInnerParamter.bfIPChangeAckFromWinApp = 1;

			netMblkClChainFree (pMblk); 
			goto EndXXX;
		}
	
		if( IsQuitUConfigPacket(pMblk) )
		{
			ExitUconfig();
			netMblkClChainFree (pMblk); 
			goto EndXXX;
		}

		if( IsuConfigArpRequestPacket(pMblk) )
		{
		    ProcessArpPacket(pMblk);

		    netMblkClChainFree (pMblk); 
			goto EndXXX;
		}	

        if( IsPCIPCHANGEDUConfigPacket(pMblk) )
        {  //PC/workstation's IP is changed

            ProcessPCIPChangedPacket(pMblk);
            netMblkClChainFree (pMblk); 
			goto EndXXX;
        
            
        }
	}
	
	semGive (uConfigInnerParamter.semB);
	return uConfigInnerParamter.oldLanEndRtn(pCookie, pMblk); 
	
EndXXX:
	
	/*taskUnLock();		*/
	semGive (uConfigInnerParamter.semB);	
	return TRUE;	
}


BOOL UconfigLanSendMacHook(END_OBJ* pEndObj, M_BLK_ID pMblk) 
{	    
	//????SGH: why this send hook cannot use sem, but recv hook can 
    STATUS res;

	//semTake(uConfigInnerParamter.semB, WAIT_FOREVER);

	if( uCfgData.bfAreadyUconfig )
	{
		if( IsArpPacketSamewithDeceivingGateway(pMblk) )
		{
			//printf("arp output packet delete \r\n");
			netMblkClChainFree (pMblk);
			goto ENDXXX;
		}
	}

	//semGive(uConfigInnerParamter.semB);

	res = uConfigInnerParamter.oldLanEndSend(pEndObj, pMblk);


  	return res;

ENDXXX:
	//semGive(uConfigInnerParamter.semB);
	return OK;
}


void GetLanMac(char* Name, int unit, char *Mac)
{
	char buf[20];	
	struct ifnet *pIf;

	sprintf(buf,"%s%d", Name, unit);
	pIf = ifunit(buf);
	if( pIf == NULL) 
	{
		printf("Error: Lan pIF is null\r\n");
		taskDelay(1000000000);
	}
	memcpy(Mac, ((struct arpcom *)(pIf))->ac_enaddr, 6);
}

/* sysmsg_send_packet */
static BOOL ReplyNPFindPacket( M_BLK_ID pMblk)
{
	struct ip *pip = (struct ip *)( (char *)(pMblk->mBlkHdr.mData) + 14);
    SYSMSG_UCONFIG_PACKET *pRecvPakcet = (SYSMSG_UCONFIG_PACKET *) ( (char *)(pip) + pip->ip_hl * 4 + 8); /* 8--udp header */

       /*In old NPFInd.exe, there is no Src_ip, Src_mac, Dest_ip, Dest_Mac and so on*/
    if( ntohl( pRecvPakcet->version) < NPFIND_PROT_VERSION)
    	SendPacket2( SYSMSG_CODE_NPFIND_REPLY, uConfigInnerParamter.LanPortIP, uConfigInnerParamter.LanPortIP, 
    	 inet_addr("255.255.255.255"), BroadCastMac, ntohl( pRecvPakcet->version) );
    else 
    	SendPacket( SYSMSG_CODE_NPFIND_REPLY, 
    	           uConfigInnerParamter.LanPortIP, uConfigInnerParamter.LanPortIP, 
    	           pRecvPakcet->Src_ip, pRecvPakcet->Src_mac);
    
    return TRUE;
}


static BOOL SetUConfigStatus( M_BLK_ID pMblk)
{	
	struct ip *pip = (struct ip *)( (char *)(pMblk->mBlkHdr.mData) + 14);
    SYSMSG_UCONFIG_PACKET *pRecvPakcet = (SYSMSG_UCONFIG_PACKET *) ( (char *)(pip) + pip->ip_hl * 4 + 8); /* 8--udp header */
    
    char Str_Mac[30];
    char Str_WS_IP[16];
    char Str_Lan_IP[16];
    char Str_gateway_IP[16];
    


	//compare device's ip ( mac already compare in function Get..
	if( pRecvPakcet->Dest_ip != uConfigInnerParamter.LanPortIP)    //not same with old WS/uConfig for network adaptor IP
	{
		printf("Device IP error\r\n");
		goto DENY;
	}		
	
	if( uCfgData.bfAreadyUconfig) 
	{  //already uConfig mode
		//compare old ws/uCOnfig.exe's mac
		if( memcmp( uCfgData.WS_Mac, pRecvPakcet->Src_mac, 6) != 0 )  //not same with old WS/uConfig for network adaptor mac
		{
			goto DENY;
		}
		
		//compare old ws/uCOnfig.exe's mac	
		if( pRecvPakcet->Src_ip != uCfgData.WS_IP)    //not same with old WS/uConfig for network adaptor IP
		{
			goto DENY;
		}

		//same to old WS/uConfig.exe, then update WS's host gateway for uConfig
		uCfgData.WS_DeceivingHostGateway = pRecvPakcet->Deceiving_Host_gateway;

		SaveUconfigData();
	}
	else
	{  //not entered uconfig, so now prepare to enter uConfig mode 	
	
		inet_ntoa_b( *(struct in_addr *)&pRecvPakcet->Src_ip , Str_WS_IP );
		if( inet_addr( Str_WS_IP ) == (ULONG) ERROR )
		{			
			goto DENY;
		}	
		memset( Str_WS_IP, 0, sizeof(Str_WS_IP) );
		
		if(  (memcmp( pRecvPakcet->Src_mac, ZeroMac, 6) == 0) ||
			(memcmp( pRecvPakcet->Src_mac, BroadCastMac, 6) == 0) )
		{
			goto DENY;
		}

		uCfgData.bfAreadyUconfig = 1;
		
		HTTPMSGInit();
		update_menu_htm();		
		
	    /*renew and save uCfgData*/
		memcpy( &uCfgData.WS_IP, &pRecvPakcet->Src_ip, 4);
	    memcpy( uCfgData.WS_Mac, pRecvPakcet->Src_mac, 6);
	    uCfgData.WS_DeceivingHostGateway = pRecvPakcet->Deceiving_Host_gateway;
	    SaveUconfigData();
		//SaveUconfigData();
	    
		sprintf( Str_Mac, "%02x:%02x:%02x:%02x:%02x:%02x", 
			    uCfgData.WS_Mac[0], uCfgData.WS_Mac[1], uCfgData.WS_Mac[2],
			    uCfgData.WS_Mac[3], uCfgData.WS_Mac[4], uCfgData.WS_Mac[5] );
		
		/* cal deceit gateway */
		if( ( uConfigInnerParamter.LanPortIP & uConfigInnerParamter.LanPortMask) == ( uCfgData.WS_IP& uConfigInnerParamter.LanPortMask) ) /*if same subnet*/
			uConfigInnerParamter.gatewayIP = uCfgData.WS_IP;
		else
		{
			if( ( ntohl( uConfigInnerParamter.LanPortIP) & 0x1) == 0x1 )
				uConfigInnerParamter.gatewayIP = 2;
			else 
				uConfigInnerParamter.gatewayIP = 1;
		 	uConfigInnerParamter.gatewayIP |= ntohl( uConfigInnerParamter.LanPortIP) & ntohl( uConfigInnerParamter.LanPortMask);
		 	uConfigInnerParamter.gatewayIP = htonl(uConfigInnerParamter.gatewayIP);
		}

 	 	
		inet_ntoa_b( *(struct in_addr *)&uCfgData.WS_IP , Str_WS_IP );
		inet_ntoa_b( *(struct in_addr *)&uConfigInnerParamter.gatewayIP, Str_gateway_IP);
		inet_ntoa_b( *(struct in_addr *)&uConfigInnerParamter.LanPortIP, Str_Lan_IP);

	    arpDelete( Str_gateway_IP );
		routeDelete( Str_WS_IP, "0.0.0.0" );
		routeDelete( Str_gateway_IP, Str_Lan_IP );

		if( arpAdd ( Str_gateway_IP, Str_Mac, ATF_PERM|ATF_PUBL ) == ERROR )
		{
			printf("arpadd error 2 : IP-%s, Mac-%s\r\n", Str_gateway_IP, Str_Mac);
			uCfgData.bfAreadyUconfig = 0;
			goto DENY;
		}

		/* first use host route */
		if( routeAdd( Str_WS_IP, Str_gateway_IP ) == ERROR )
		{
			printf("route add error 1, so can't process uconfig now(%s %s)\r\n", Str_WS_IP, Str_gateway_IP);
			uCfgData.bfAreadyUconfig = 0;
			goto DENY;
		}    
	
	}

	/* add to tell windows application that the command has received */
	SendPacket( SYSMSG_CODE_BEGIN_UCONFIG_ACK, uConfigInnerParamter.LanPortIP, uConfigInnerParamter.LanPortIP, uCfgData.WS_IP, uCfgData.WS_Mac);
	
	return TRUE;

DENY: 
	SendPacket( SYSMSG_CODE_BEGIN_UCONFIG_DENY, uConfigInnerParamter.LanPortIP, uConfigInnerParamter.LanPortIP, 
			   pRecvPakcet->Src_ip, pRecvPakcet->Src_mac );
	return FALSE;
	

}


/* sysmsg_process_packet */
BOOL IsNPFindPacket(M_BLK_ID pMblk)
{
	if( GetUConfigPacketType( pMblk ) == SYSMSG_CODE_NPFIND_QUERY ) 
		return TRUE;
	else return FALSE;
}

ULONG GetUConfigPacketType(M_BLK_ID pMblk)
{
	struct ip *pip = (struct ip *)( (char *)(pMblk->mBlkHdr.mData) + 14);
	struct udphdr *pUdp;
    SYSMSG_UCONFIG_PACKET * pRecvPacket;
    unsigned long tmpL;

	if( pMblk == NULL ) return 0;
                                                         /* Mac  IP  UDP the least bytes of uCOnfig data */
	if( (pMblk->mBlkHdr.mLen > 1514 ) || (pMblk->mBlkHdr.mLen < 14 + 20 + 8 + 12) )
		return 0;
	       
    if( pip->ip_p != IP_PROTO_UDP )  return 0;
    
    pUdp = (struct udphdr *)( (char *)(pip) + pip->ip_hl * 4 );

    if( ntohs(pUdp->uh_sport) != UCONFING_NPFIND_UDP_PORT ||
        ntohs(pUdp->uh_dport) != UCONFING_NPFIND_UDP_PORT )
    	return 0;
       
    pRecvPacket = (SYSMSG_UCONFIG_PACKET *) ( (char *)(pip) + pip->ip_hl * 4 + 8); /* 8--udp header */

   	memcpy( &tmpL, &pRecvPacket->magic_number, 4);
    if ( tmpL != htonl(NPFIND_MAGIC_NUMBER))
    {
        return 0;
    }

	memcpy( &tmpL, &pRecvPacket->code, 4);
	tmpL = ntohl( tmpL );
	//printf("tmpL = %d\r\n", tmpL );
	if( tmpL == SYSMSG_CODE_NPFIND_QUERY ) return tmpL;		

	/*I put it here in order to be compitable with old NPFin.exe */	
	if( pMblk->mBlkHdr.mLen < 14 + 20 + 8 + sizeof(SYSMSG_UCONFIG_PACKET)  ) return 0;
	if( ntohl(pRecvPacket->version) < NPFIND_PROT_VERSION ) return 0;
	if( memcmp( pRecvPacket->Src_mac, &pMblk->mBlkHdr.mData[6], 6) != 0) return 0;
		
	if( tmpL == SYSMSG_CODE_BEGIN_UCONFIG) return tmpL;

	/*check if the mac is the correct network adaptor mac/uConfig.exe*/
	if( memcmp( uCfgData.WS_Mac, pRecvPacket->Src_mac, 6) != 0) 
	{	
		return 0;
	}

	/*check if the ip is the correct network adaptor ip/uCOnfig.exe */	
	/* 2000.6.12 delete it for PC's ip can be changed especially PC works on DHCP mode
	if( uCfgData.WS_IP != pRecvPacket->Src_ip)
	{
		return 0;
	}*/

	/*check if target mac is local uCOnfig mac*/
	if( memcmp(uConfigInnerParamter.LanPortMac, pRecvPacket->Dest_mac, 6) != 0) 
	{
		return 0;
	}

#if 0 /*maybe some problem during changing uConfig's IP */
	if( memcmp(uConfigInnerParamter.LanPortIP, pRecvPacket->Dest_ip, 6) != 0) 
	{
		return 0;
	}
#endif

END:

	return tmpL;
}

BOOL IsBeginUConfigPacket(M_BLK_ID pMblk)	
{
    if ( GetUConfigPacketType(pMblk) != SYSMSG_CODE_BEGIN_UCONFIG)
        return FALSE;
    else 
    	return TRUE;
}

/****************************************************************
  if device has not enter uConfig mode at this time,
      Then Begin enter uConfig mode;
  else if device has already enter uConfig mode, 
      Then compare if current workstation(uConfig.exe) is same as old,
          If yes, then respond with ACK packet
          else deny it with DENY packet    

****************************************************************/
BOOL IsNeedEnteUConfigMode(M_BLK_ID pMblk )
{  //must be first checked that the packte is an Begin Config command packet
	struct ip *pip = (struct ip *)( (char *)(pMblk->mBlkHdr.mData) + 14);
	SYSMSG_UCONFIG_PACKET *packet;
	char tmpIP[20];

	if( pip->ip_p != IP_PROTO_UDP )
    {
    	return FALSE;
    }
	
	packet = (SYSMSG_UCONFIG_PACKET *) ( (char *)(pip) + pip->ip_hl * 4 + 8); /* 8--udp header */

	//compare device's mac
	if( memcmp( uConfigInnerParamter.LanPortMac, packet->Dest_mac, 6) != 0 )  //not same with old WS/uConfig for network adaptor mac
	{
		goto DENY;
	}

	//compare device's ip 
	if( packet->Dest_ip != uConfigInnerParamter.LanPortIP)    //not same with old WS/uConfig for network adaptor IP
	{
		goto DENY;
	}		
	
	if( uCfgData.bfAreadyUconfig) 
	{  //already uConfig mode
		//compare old ws/uCOnfig.exe's mac
		if( memcmp( uCfgData.WS_Mac, packet->Src_mac, 6) != 0 )  //not same with old WS/uConfig for network adaptor mac
		{
			goto DENY;
		}
		
		//compare old ws/uCOnfig.exe's mac	
		if( packet->Src_ip != uCfgData.WS_IP)    //not same with old WS/uConfig for network adaptor IP
		{
			goto DENY;
		}

		//same to old WS/uConfig.exe, then update WS's host gateway for uConfig
		uCfgData.WS_DeceivingHostGateway = packet->Deceiving_Host_gateway;		
	}			

	return TRUE;

DENY:

	return FALSE;
}

BOOL IsIPChangedACKUConfigPacket(M_BLK_ID pMblk)	
{
    if ( GetUConfigPacketType(pMblk) != SYSMSG_CODE_CHANGE_IP_ACK )
        return FALSE;
    else 
    	return TRUE;	
}

BOOL IsQuitUConfigPacket(M_BLK_ID pMblk)	
{
    if ( GetUConfigPacketType(pMblk) != SYSMSG_CODE_CLOSE_UCONFIG )
    	return FALSE;
    else 
    	return TRUE;           
}

BOOL IsPCIPCHANGEDUConfigPacket(M_BLK_ID pMblk)	
{
    if ( GetUConfigPacketType(pMblk) != SYSMSG_CODE_PC_IP_CHANGED )
    	return FALSE;
    else 
    	return TRUE;           
}


/*Before use it, its original checksum must be set to 0 */
unsigned long checksum_d ( unsigned char *buf, int nbytes, unsigned long sum)	
{
	int i;	

	for (i = 0; i < (nbytes & ~1); i += 2) 
	{
		sum += (unsigned short) ntohs(*((unsigned short *)(buf + i))); 
		/* Add carry. */		
		if (sum > 0xFFFF)			
			sum -= 0xFFFF;
	}	

	/* If there's a single byte left over, checksum it, too.   Network	   byte order is big-endian, so the remaining byte is the high byte. */	
	if (i < nbytes) 
	{
		sum += buf [i] << 8;		
		/* Add carry. */		
		if (sum > 0xFFFF)			
			sum -= 0xFFFF;	
	}

	return sum;
	
}

unsigned long wrapsum (	unsigned long sum)
{
	sum = ~sum & 0xFFFF;
	return htons(sum);
}


/**********************************************
NewIP and OldIP are all network byte order:
call it when lan port ip is changed
**********************************************/
BOOL SendPacket(ULONG mode, ULONG NewIP, ULONG OldIP, ULONG DestIP, char *DestMac)
{       
	struct ether_header sysmsg_ether_header;
	struct ip         sysmsg_ip;
	struct udphdr     sysmsg_udp;
	int 			  length = 0;
	
	//memset(&sysmsg_ether_header.ether_dhost[0], 0xff, 6);
	memcpy(&sysmsg_ether_header.ether_dhost[0], DestMac, 6);
    sysmsg_ether_header.ether_type = 0x0800;
        
    /* Fill in the IP header */
    sysmsg_ip.ip_v = 4;
    sysmsg_ip.ip_hl = 5;
    sysmsg_ip.ip_tos = 0;
    sysmsg_ip.ip_len = htons(sizeof(sysmsg_ip) + sizeof(sysmsg_udp) + sizeof(SYSMSG_UCONFIG_PACKET));
    sysmsg_ip.ip_off = 0;
    sysmsg_ip.ip_ttl = 1;
    sysmsg_ip.ip_p = IPPROTO_UDP;
        
    /* Fill in the UDP header */
    sysmsg_udp.uh_sport = htons(UCONFING_NPFIND_UDP_PORT);
    sysmsg_udp.uh_dport = htons(UCONFING_NPFIND_UDP_PORT);
    sysmsg_udp.uh_ulen  = htons(sizeof(sysmsg_udp) + sizeof(SYSMSG_UCONFIG_PACKET));
    sysmsg_udp.uh_sum   = 0;

    /* Fill in the packet */
    uConfigInterfacePacket.magic_number = htonl(NPFIND_MAGIC_NUMBER);
    uConfigInterfacePacket.version  = htonl(NPFIND_PROT_VERSION);
    uConfigInterfacePacket.code      = htonl( mode );
    
    /* ip header */
    sysmsg_ip.ip_id = (u_short) rand();
    sysmsg_ip.ip_sum = 0;
    sysmsg_ip.ip_src.s_addr = NewIP;
    
    /* fill in system name, and ip/mac address */
    uConfigInterfacePacket.ip_address = NewIP;    
   	uConfigInterfacePacket.old_ip_address = OldIP;    
    sysmsg_ip.ip_dst.s_addr = DestIP;//inet_addr("255.255.255.255");
    uConfigInterfacePacket.Src_ip = NewIP;
    uConfigInterfacePacket.Dest_ip = DestIP;
    memcpy(uConfigInterfacePacket.Src_mac, uConfigInnerParamter.LanPortMac, 6);
    memcpy( uConfigInterfacePacket.Dest_mac, DestMac, 6);
    if( uCfgData.bfAreadyUconfig ) 
    	uConfigInterfacePacket.bfUconfigMode = 1;
    else 
    	uCfgData.bfAreadyUconfig = 0;
    
    /* Checksum the IP header... */
    sysmsg_ip.ip_sum = wrapsum (checksum_d ((unsigned char *)&sysmsg_ip, sizeof(sysmsg_ip), 0));
    
    /* Copy the ip header into the buffer... */
    memcpy (&uConfigInnerParamter.sysmsg_tx_buffer[length], &sysmsg_ip, sizeof(sysmsg_ip ));
    length += sizeof( sysmsg_ip);

    /* Copy the udp header into the buffer... */
    memcpy (&uConfigInnerParamter.sysmsg_tx_buffer[length], &sysmsg_udp, sizeof(sysmsg_udp));
    length += sizeof( sysmsg_udp);

    /* Copy the SYSMSG header into the buffer... */
    memcpy (&uConfigInnerParamter.sysmsg_tx_buffer[length], &uConfigInterfacePacket, sizeof(SYSMSG_UCONFIG_PACKET));
    length += sizeof(SYSMSG_UCONFIG_PACKET);
   
    if( etherOutput(uConfigInnerParamter.sysmsg_if, &sysmsg_ether_header, uConfigInnerParamter.sysmsg_tx_buffer, length) == ERROR)
	{
		printf("etherOutput error in SendPacket\r\n");
	}
     	
    return TRUE;
}

/*for comptible with old NPFind.exe */
BOOL SendPacket2(ULONG mode, ULONG NewIP, ULONG OldIP, ULONG DestIP, char *DestMac, ULONG version)
{       
	struct ether_header sysmsg_ether_header;
	struct ip         sysmsg_ip;
	struct udphdr     sysmsg_udp;
	int 			  length = 0;
	
	//memset(&sysmsg_ether_header.ether_dhost[0], 0xff, 6);
	memcpy(&sysmsg_ether_header.ether_dhost[0], DestMac, 6);
    sysmsg_ether_header.ether_type = 0x0800;
        
    /* Fill in the IP header */
    sysmsg_ip.ip_v = 4;
    sysmsg_ip.ip_hl = 5;
    sysmsg_ip.ip_tos = 0;
    sysmsg_ip.ip_len = htons(sizeof(sysmsg_ip) + sizeof(sysmsg_udp) + sizeof(SYSMSG_UCONFIG_PACKET));
    sysmsg_ip.ip_off = 0;
    sysmsg_ip.ip_ttl = 1;
    sysmsg_ip.ip_p = IPPROTO_UDP;
        
    /* Fill in the UDP header */
    sysmsg_udp.uh_sport = htons(UCONFING_NPFIND_UDP_PORT);
    sysmsg_udp.uh_dport = htons(UCONFING_NPFIND_UDP_PORT);
    sysmsg_udp.uh_ulen  = htons(sizeof(sysmsg_udp) + sizeof(SYSMSG_UCONFIG_PACKET));
    sysmsg_udp.uh_sum   = 0;

    /* Fill in the packet */
    uConfigInterfacePacket.magic_number = htonl(NPFIND_MAGIC_NUMBER);
    uConfigInterfacePacket.version  = htonl(version);
    uConfigInterfacePacket.code      = htonl( mode );
    
    /* ip header */
    sysmsg_ip.ip_id = (u_short) rand();
    sysmsg_ip.ip_sum = 0;
    sysmsg_ip.ip_src.s_addr = NewIP;
    
    /* fill in system name, and ip/mac address */
    uConfigInterfacePacket.ip_address = NewIP;    
   	uConfigInterfacePacket.old_ip_address = OldIP;    
    sysmsg_ip.ip_dst.s_addr = DestIP;//inet_addr("255.255.255.255");
    uConfigInterfacePacket.Src_ip = NewIP;
    uConfigInterfacePacket.Dest_ip = DestIP;
    memcpy(uConfigInterfacePacket.Src_mac, uConfigInnerParamter.LanPortMac, 6);
    memcpy( uConfigInterfacePacket.Dest_mac, DestMac, 6);
    
    /* Checksum the IP header... */
    sysmsg_ip.ip_sum = wrapsum (checksum_d ((unsigned char *)&sysmsg_ip, sizeof(sysmsg_ip), 0));
    
    /* Copy the ip header into the buffer... */
    memcpy (&uConfigInnerParamter.sysmsg_tx_buffer[length], &sysmsg_ip, sizeof(sysmsg_ip ));
    length += sizeof( sysmsg_ip);

    /* Copy the udp header into the buffer... */
    memcpy (&uConfigInnerParamter.sysmsg_tx_buffer[length], &sysmsg_udp, sizeof(sysmsg_udp));
    length += sizeof( sysmsg_udp);

    /* Copy the SYSMSG header into the buffer... */
    memcpy (&uConfigInnerParamter.sysmsg_tx_buffer[length], &uConfigInterfacePacket, sizeof(SYSMSG_UCONFIG_PACKET));
    length += sizeof(SYSMSG_UCONFIG_PACKET);
   
    if( etherOutput(uConfigInnerParamter.sysmsg_if, &sysmsg_ether_header, uConfigInnerParamter.sysmsg_tx_buffer, length) == ERROR)
	{
		printf("etherOutput error in SendPacket\r\n");
	}
     	
    return TRUE;
    

}


void ExitUconfigTask()
{
	int i = 0;
	BOOL bfNeedProcess = FALSE;

	uConfigInnerParamter.bfRebooting = TRUE;
	if( uCfgData.bfAreadyUconfig )
		bfNeedProcess = TRUE;

	taskDelay(25); /* wait one http page send to ws_IP */
		
	uCfgData.bfAreadyUconfig = 0;

	for( i= 0; i< 7; i++)
	{ /*tell to windows application */		
		SendPacket( SYSMSG_CODE_CLOSE_UCONFIG, uConfigInnerParamter.LanPortIP, uConfigInnerParamter.LanPortIP, uCfgData.WS_IP , uCfgData.WS_Mac);
		taskDelay(1);
	}

	if( bfNeedProcess )
	{	
		char Str_WS_IP[16];
		char Str_gateway_IP[16];
		char Str_Lan_IP[16];
		
		inet_ntoa_b( *(struct in_addr *)&uCfgData.WS_IP , Str_WS_IP );
		inet_ntoa_b( *(struct in_addr *)&uConfigInnerParamter.gatewayIP, Str_gateway_IP);
		inet_ntoa_b( *(struct in_addr *)&uConfigInnerParamter.LanPortIP, Str_Lan_IP);
		arpDelete( Str_gateway_IP );		
		routeDelete( Str_WS_IP, "0.0.0.0" );
		routeDelete( Str_gateway_IP, Str_Lan_IP );				
	}

	SetDefaultUconfigData();
	SaveUconfigData();		

	taskDelay( 12 );
	reboot(2);

}

void ExitUconfig()
{
	static BOOL bfAlreadyExitUconfig = FALSE;
	int i =0 ;

	if( bfAlreadyExitUconfig ) return;
	
	bfAlreadyExitUconfig = TRUE;

	for( i= 0; i<10; i++)
	{
		SendPacket( SYSMSG_CODE_CLOSE_UCONFIG_ACK, uConfigInnerParamter.LanPortIP, uConfigInnerParamter.LanPortIP, uCfgData.WS_IP , uCfgData.WS_Mac);
		taskDelay( 1 );
	}
		
	
	taskSpawn( "TaskExitUconfig", 150, VX_PRIVATE_ENV, 5000, (FUNCPTR )ExitUconfigTask,
	                                 0,0,0,0,0,0,0,0,0,0); 	
}


/***It is used outside here */
void ReNewUconfigLanPortattr(char *LanIP, char *Mask)
{
	char Str_Mac[30];
	char Str_WS_IP[16];
	char Str_Gateway_IP[16];
	char Str_Lan_IP[16];

	semTake (uConfigInnerParamter.semB, WAIT_FOREVER);

	if( uCfgData.bfAreadyUconfig == 0) //hasnot enter uConfig mode. So don't do anything except save something
	{
		uConfigInnerParamter.LanPortMask = inet_addr(Mask);
		uConfigInnerParamter.LanPortIP = inet_addr(LanIP);
		semGive (uConfigInnerParamter.semB);
		return ;
	}
	
	if( ( uConfigInnerParamter.LanPortIP == inet_addr(LanIP) ) /*&&
		( uConfigInnerParamter.LanPortMask == inet_addr(Mask) )*/ )
	{
		semGive (uConfigInnerParamter.semB);
		return ;
	}
	
	/*Frist tell Windows Uconfig.exe that its ip has been chanded*/
	if( uConfigInnerParamter.LanPortIP != inet_addr(LanIP) )
	{	 /*Tell WS that its ip is changed now */
		uConfigInnerParamter.bfIPChangeAckFromWinApp = 0; /*clear it*/
		SendPacket( SYSMSG_CODE_CHANGE_IP, inet_addr(LanIP), uConfigInnerParamter.LanPortIP, uCfgData.WS_IP, uCfgData.WS_Mac);

		if( uConfigInnerParamter.UconfigTaskID == 0) 
		{
			uConfigInnerParamter.UconfigTaskID = taskSpawn( "TaskUconfig", 120, VX_PRIVATE_ENV, 5000, (FUNCPTR )UconfigTask,
	                                 0,0,0,0,0,0,0,0,0,0); 
			if( uConfigInnerParamter.UconfigTaskID == ERROR) 
			{
				printf("Error to create a task in SetUconfigWithLanPort\r\n");
			}
		}
		HTTPMSGInit();
		update_menu_htm();		
			
	}
		
	/*delete old deciet route and old arp table*/
	inet_ntoa_b( *(struct in_addr *)&uCfgData.WS_IP, Str_WS_IP);
	inet_ntoa_b( *(struct in_addr *)&uConfigInnerParamter.gatewayIP , Str_Gateway_IP );
	inet_ntoa_b( *(struct in_addr *)&uConfigInnerParamter.LanPortIP, Str_Lan_IP);
	routeDelete( Str_WS_IP, "0.0.0.0" );
	routeDelete( Str_Gateway_IP,  Str_Lan_IP );	
	arpDelete( Str_Gateway_IP );

	/*renew lan port ip and mask*/
	uConfigInnerParamter.LanPortMask = inet_addr(Mask);
	uConfigInnerParamter.LanPortIP = inet_addr(LanIP);
	
	/*cal new gateway*/
	if( ( uConfigInnerParamter.LanPortIP & uConfigInnerParamter.LanPortMask) == ( uCfgData.WS_IP& uConfigInnerParamter.LanPortMask) ) /*if same subnet*/
		uConfigInnerParamter.gatewayIP = uCfgData.WS_IP;
	else
	{
		if( ( ntohl( uConfigInnerParamter.LanPortIP) & 0x1) == 0x1 )
			uConfigInnerParamter.gatewayIP = 2;
		else 
			uConfigInnerParamter.gatewayIP = 1;
	 	uConfigInnerParamter.gatewayIP |= ntohl( uConfigInnerParamter.LanPortIP) & ntohl( uConfigInnerParamter.LanPortMask);
	 	uConfigInnerParamter.gatewayIP = htonl(uConfigInnerParamter.gatewayIP); 		
	}

	/* renew route table and arp table */
	inet_ntoa_b( *(struct in_addr *)&uConfigInnerParamter.gatewayIP , Str_Gateway_IP );
	sprintf( Str_Mac, "%02x:%02x:%02x:%02x:%02x:%02x", 
		        uCfgData.WS_Mac[0], uCfgData.WS_Mac[1], uCfgData.WS_Mac[2],
		        uCfgData.WS_Mac[3], uCfgData.WS_Mac[4], uCfgData.WS_Mac[5] );	
	
	arpDelete( Str_Gateway_IP);	

	if( arpAdd ( Str_Gateway_IP, Str_Mac, ATF_PERM|ATF_PUBL  ) == ERROR )
	{
		printf("arpadd error: IP-%s, Mac-%s\r\n", Str_Gateway_IP, Str_Mac);
	}	

	if( routeAdd( Str_WS_IP, Str_Gateway_IP ) == ERROR )
	{
		printf("route add error 2, so can't process uconfig now(%s %s)\r\n", Str_WS_IP, Str_Gateway_IP);
	}

	semGive (uConfigInnerParamter.semB);
	
}


BOOL IsuConfigArpRequestPacket( M_BLK_ID pMblk)	
{
	ARP *arp = ( ARP *)(pMblk->mBlkHdr.mData + 14);
	
	if(  pMblk->mBlkHdr.mData[12] != 0x08 ||
		 pMblk->mBlkHdr.mData[13] != 0x06 )
		 return FALSE;
		
	if( ntohs(arp->opcode) != 1 ) /*not arp requst*/
		return FALSE;

	if( memcmp( &arp->sender_ip, &arp->target_ip, 4) == 0) /*tarte_ip and sender_ip are same*/
		return FALSE;
	
	/*check if the mac is the correct network adaptor mac/uConfig.exe*/
	if( memcmp( uCfgData.WS_Mac, arp->sender_mac, 6) != 0) 
	{
		return FALSE;
	}

	/*check if target ip is local uCOnfig ip*/
	if( uCfgData.WS_IP != arp->sender_ip.s_addr )
	{
		return FALSE;
	}

	/*check if the ip is uConfig.exe's deceiving host route's gateway*/
	if( uCfgData.WS_DeceivingHostGateway != arp->target_ip.s_addr)
	{
		return FALSE;
	}

	return TRUE;

}

BOOL ProcessArpPacket(  M_BLK_ID pMblk)
{
	SendPacket( SYSMSG_CODE_NEED_NEW_ARP, uConfigInnerParamter.LanPortIP, uConfigInnerParamter.LanPortIP, 
               uCfgData.WS_IP, uCfgData.WS_Mac);

	return TRUE;

}

/************************************************************************
   SetUconfigDataMemAddr_Read: must be called after Lan port ip/mask is set.
   Note, it is must first be called after SetUconfigWithLanPort(...)

   Lan port ip/mask must be set( Reason: modify route table )
*************************************************************************/
BOOL SetUconfigDataMemAddr_Read( struct UconfigData *puCfgData, int bfColdReBoot)
{
	char Str_WS_IP[16];
	char Str_Gateway_IP[16];
	char Str_Mac[32];
	int   i;
	
	if( puCfgData == NULL )
	{
		printf("puCfgData is null in SetUconfigDataMemAddr_Read(...)\r\n");
		return FALSE;
	}
		
	pUCfgDataInConfigFile = puCfgData;	

	memcpy( &uCfgData, puCfgData, sizeof(uCfgData) );
		
	if( bfColdReBoot ) /*cold reboot*/
	{   /*need to clear uconfig data, ie, not enter into uconfig mode*/
		BOOL bfNeedSetDefault = FALSE;

		if( strcmp( uCfgData.Magic1, UCONFIG_MAGIC_STR1 ) != 0 ||   strcmp( uCfgData.Magic2, UCONFIG_MAGIC_STR2 ) != 0 ) 
		{
			bfNeedSetDefault = TRUE;
		}
		else if( uCfgData.bfAreadyUconfig ) 
		{
			bfNeedSetDefault = TRUE;
		}
		
		if( bfNeedSetDefault )
		{	
		    for( i= 0; i< 7; i++)
        	{ /*tell to windows application */		
        		SendPacket( SYSMSG_CODE_CLOSE_UCONFIG, uConfigInnerParamter.LanPortIP, uConfigInnerParamter.LanPortIP, uCfgData.WS_IP , uCfgData.WS_Mac);
        		taskDelay(1);
        	}
		    
			SetDefaultUconfigData();						
			SaveUconfigData();			
		}
	}
	else /*warm reboot */
	{		
		if( strcmp( uCfgData.Magic1, UCONFIG_MAGIC_STR1 ) != 0 || 
		   strcmp( uCfgData.Magic2, UCONFIG_MAGIC_STR2 ) != 0 ) 
		{		
			SetDefaultUconfigData();
			SaveUconfigData();

			SendPacket( SYSMSG_CODE_CLOSE_UCONFIG, uConfigInnerParamter.LanPortIP, uConfigInnerParamter.LanPortIP, uCfgData.WS_IP, uCfgData.WS_Mac);
			taskDelay(2);
			SendPacket( SYSMSG_CODE_CLOSE_UCONFIG, uConfigInnerParamter.LanPortIP, uConfigInnerParamter.LanPortIP, uCfgData.WS_IP, uCfgData.WS_Mac);
			taskDelay(2);
			SendPacket( SYSMSG_CODE_CLOSE_UCONFIG, uConfigInnerParamter.LanPortIP, uConfigInnerParamter.LanPortIP, uCfgData.WS_IP, uCfgData.WS_Mac);
			taskDelay(2);
			SendPacket( SYSMSG_CODE_CLOSE_UCONFIG, uConfigInnerParamter.LanPortIP, uConfigInnerParamter.LanPortIP, uCfgData.WS_IP, uCfgData.WS_Mac);

		}
		else if( uCfgData.bfAreadyUconfig)
		{  
		    if( ( uConfigInnerParamter.LanPortIP & uConfigInnerParamter.LanPortMask) == ( uCfgData.WS_IP& uConfigInnerParamter.LanPortMask) ) /*if same subnet*/
				uConfigInnerParamter.gatewayIP = uCfgData.WS_IP;
			else
			{
				if( ( ntohl( uConfigInnerParamter.LanPortIP) & 0x1) == 0x1 )
					uConfigInnerParamter.gatewayIP = 2;
				else 
					uConfigInnerParamter.gatewayIP = 1;	
			 	uConfigInnerParamter.gatewayIP |= ntohl( uConfigInnerParamter.LanPortIP) & ntohl( uConfigInnerParamter.LanPortMask);
			 	uConfigInnerParamter.gatewayIP = htonl(uConfigInnerParamter.gatewayIP);
			}
			
			
		 	
			/* renew route table and arp table */			
			inet_ntoa_b( *(struct in_addr *)&uCfgData.WS_IP , Str_WS_IP );
			inet_ntoa_b( *(struct in_addr *)&uConfigInnerParamter.gatewayIP , Str_Gateway_IP );
			sprintf( Str_Mac, "%02x:%02x:%02x:%02x:%02x:%02x", 
				        uCfgData.WS_Mac[0], uCfgData.WS_Mac[1], uCfgData.WS_Mac[2],
				        uCfgData.WS_Mac[3], uCfgData.WS_Mac[4], uCfgData.WS_Mac[5] );

			if( arpAdd ( Str_Gateway_IP, Str_Mac, ATF_PERM|ATF_PUBL  ) == ERROR )
			{
				printf("arpadd error 3: IP-%s, Mac-%s\r\n", Str_Gateway_IP, Str_Mac);
				uCfgData.bfAreadyUconfig = 0;
			}			

			/* first use host route */
			if( routeAdd( Str_WS_IP, Str_Gateway_IP ) == ERROR )
			{
				/* if host route fail, then use default network route */
				printf("route add error 3, so can't process uconfig now(%s %s)\r\n", Str_WS_IP, Str_Gateway_IP);
				uCfgData.bfAreadyUconfig = 0;
				return FALSE;
				
			}			

			if( uConfigInnerParamter.UconfigTaskID == 0) 
			{
				uConfigInnerParamter.UconfigTaskID = taskSpawn( "TaskUconfig", 120, VX_PRIVATE_ENV, 5000, (FUNCPTR )UconfigTask,
		                                 0,0,0,0,0,0,0,0,0,0); 
				if( uConfigInnerParamter.UconfigTaskID == ERROR) 
				{
					printf("Error to create a task in SetUconfigWithLanPort\r\n");
					uCfgData.bfAreadyUconfig = 0;
				}
			}
		}
	}
	return TRUE;
}

void SetDefaultUconfigData()
{
	memset( &uCfgData, 0, sizeof(uCfgData) );

	strcpy( uCfgData.Magic1, UCONFIG_MAGIC_STR1);
	strcpy( uCfgData.Magic2, UCONFIG_MAGIC_STR2);	
}


/*need to be specified with device type*/
void SaveUconfigData( )
{
	memcpy( pUCfgDataInConfigFile, (void *)&uCfgData, sizeof(uCfgData) );
	
	CFGWriteConfig();
}
BOOL IsUconfigMode()
{
	if( uCfgData.bfAreadyUconfig == 0) 
		return FALSE;
	else return TRUE;
}

void Get_WS_MAC(char *DestMac)
{
	memcpy( DestMac, uCfgData.WS_Mac, 6);
}

void UconfigTask()
{
	while(1)
	{
		taskDelay(120);
		semTake (uConfigInnerParamter.semB, WAIT_FOREVER);
		if( uConfigInnerParamter.bfIPChangeAckFromWinApp == 0 )
		{
			SendPacket( SYSMSG_CODE_CHANGE_IP, uConfigInnerParamter.LanPortIP, uConfigInnerParamter.LanPortIP, uCfgData.WS_IP, uCfgData.WS_Mac);
			
		}
		semGive(uConfigInnerParamter.semB);		
	}
}



void ProcessPCIPChangedPacket( M_BLK_ID pMblk)
{
    struct ip *pip = (struct ip *)( (char *)(pMblk->mBlkHdr.mData) + 14);
    SYSMSG_UCONFIG_PACKET *pRecvPakcet = (SYSMSG_UCONFIG_PACKET *) ( (char *)(pip) + pip->ip_hl * 4 + 8); /* 8--udp header */
    char Str_Mac[30];
    char Str_WS_IP[16];
    char Str_Lan_IP[16];
    char Str_gateway_IP[16];  

    //printf("enter ProcessPCIPChangedPacket: %s: %s\r\n", inet_ntoa( *(struct in_addr *)&pRecvPakcet->Src_ip), inet_ntoa( *(struct in_addr *)&pip->ip_src ) );

    if( uCfgData.WS_IP != pRecvPakcet->Src_ip )
    {        
        inet_ntoa_b( *(struct in_addr *)&uCfgData.WS_IP , Str_WS_IP );
		inet_ntoa_b( *(struct in_addr *)&uConfigInnerParamter.gatewayIP, Str_gateway_IP);
		inet_ntoa_b( *(struct in_addr *)&uConfigInnerParamter.LanPortIP, Str_Lan_IP);
		sprintf( Str_Mac, "%02x:%02x:%02x:%02x:%02x:%02x", 
			    uCfgData.WS_Mac[0], uCfgData.WS_Mac[1], uCfgData.WS_Mac[2],
			    uCfgData.WS_Mac[3], uCfgData.WS_Mac[4], uCfgData.WS_Mac[5] );

        //delete old deceit arp/route table
        arpDelete( Str_gateway_IP );
		routeDelete( Str_WS_IP, "0.0.0.0" );
		routeDelete( Str_gateway_IP, Str_Lan_IP );

        memcpy( &uCfgData.WS_IP, &pRecvPakcet->Src_ip, 4);
        SaveUconfigData();
        inet_ntoa_b( *(struct in_addr *)&uCfgData.WS_IP , Str_WS_IP );

        //printf("New pc ip = %s\r\n", Str_WS_IP );


		if( arpAdd ( Str_gateway_IP, Str_Mac, ATF_PERM|ATF_PUBL ) == ERROR )
		{
			printf("arpadd error 3 : IP-%s, Mac-%s\r\n", Str_gateway_IP, Str_Mac);
			uCfgData.bfAreadyUconfig = 0;
			goto END;
		}

			
		/* host route */
		if( routeAdd( Str_WS_IP, Str_gateway_IP ) == ERROR )
		{
			printf("route add error 4, so can't process uconfig now(%s %s)\r\n", Str_WS_IP, Str_gateway_IP);
			uCfgData.bfAreadyUconfig = 0;
			goto END;
		}        
	
    }

END: 
    SendPacket( SYSMSG_CODE_PC_IP_CHANGED_ACK, 
	            uConfigInnerParamter.LanPortIP, uConfigInnerParamter.LanPortIP, 
	            uCfgData.WS_IP, uCfgData.WS_Mac);

        
               
}

void uConfigIPChange()
{
    SendPacket( SYSMSG_CODE_CHANGE_IP, uConfigInnerParamter.LanPortIP, uConfigInnerParamter.LanPortIP, uCfgData.WS_IP, uCfgData.WS_Mac);
}


BOOL IsArpPacketSamewithDeceivingGateway(M_BLK_ID pMblk)
{
	ARP *arp = ( ARP *)(pMblk->mBlkHdr.mData + 14);

	if( pMblk->mBlkHdr.mData[12] != 0x08 ||pMblk->mBlkHdr.mData[13] != 0x06 ) /*arp*/
		 return FALSE;

#if 0		
	if( ntohs(arp->opcode) != 1 ) /*not arp requst*/
		return FALSE;
#endif

	if( memcmp( &arp->sender_ip.s_addr , &uConfigInnerParamter.gatewayIP, 4 )  == 0 )
		return TRUE;

	if( memcmp( &arp->target_ip.s_addr , &uConfigInnerParamter.gatewayIP, 4 )  == 0 )
		return TRUE;

	return FALSE; 
}
