#ifndef SGH_MEMMGRM_H_
#define SGH_MEMMGRM_H_
#include "vxworks.h"
#ifdef __cplusplus
extern "C" {
#endif

typedef struct MMM_CFG
{
	size_t nBlockSize;
	size_t nBlockNum;
	BOOL bfFixed;
}MMM_CFG;

BOOL mmm_init(MMM_CFG* pmmmCfg);

void *mmm_malloc( size_t nBytes, char *ModuleName );
void *mmm_realloc( void *pBlock, size_t nBytes, char *ModuleName );
void mmm_free( void *ptr, char *ModuleName);


/* 1--show simple used memory blocks; 2---show detail used memory blocks*/
void mmm_ShowUsedMem(int nType);

/* 1--show simple free memory blocks; 2---show detail free memory blocks*/
void mmm_ShowFreeMem(int nType); 

/*show used memory according to its modulenamt */
void mmm_ShowViaModuleName(char *ModuleName, int nType);



#ifdef __cplusplus
}
#endif

#endif
