#ifndef DATAPATH_PROC_H
#define DATAPATH_PROC_H

#include <linux/kernel.h>     /*kmalloc */
#include <linux/ctype.h>
#include <linux/proc_fs.h>    /*file_operations*/
#include <linux/seq_file.h>   /*seq_file */
#include <asm/uaccess.h>      /*copy_from_user*/


typedef void (*ltq_proc_single_callback_t)(struct seq_file *);
typedef int (*ltq_proc_callback_t)(struct seq_file *, int);
typedef int (*ltq_proc_init_callback_t)(void);
typedef ssize_t (*ltq_proc_write_callback_t )(struct file *file, 
	const char __user *input, size_t size, loff_t *loff);

struct ltq_proc_file_entry {
	ltq_proc_callback_t callback;
	int pos;
};

struct ltq_proc_entry {
	char *name;
	ltq_proc_single_callback_t single_callback;
	ltq_proc_callback_t callback;
	ltq_proc_init_callback_t init_callback;
	ltq_proc_write_callback_t write_callback;
	struct file_operations ops;
};


void ltq_proc_entry_create(struct proc_dir_entry *parent_node,
	struct ltq_proc_entry *proc_entry);

#endif /*DATAPATH_PROC_H */
